﻿/*	VERSION:  1.1

1.1		Allow parameters

USAGE:
	my_func = function(){
		trace("derp?");
	}
	
	my_infrequent_func = updateOnce( my_func );
	
	// only runs once
	my_infrequent_func();
	my_infrequent_func();
	my_infrequent_func();
	my_infrequent_func();
*/
updateOnce = function( func ){
	var hasUpdated = false;
	var interval = null;
	return function(){
		if(hasUpdated === false){
			// don't run again for awhile
			hasUpdated = true;
			
			// run the function
			func.apply( null, arguments );
			
			// wait before allowing it to be run again
			clearTimeout( interval );
			setTimeout(function(){
				hasUpdated = false;
			}, 0);
		}// if:  has NOT run yet
	}// return new func()
}// updateOnce()